<!doctype html>
<html lang="tr">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>
        <?php 
        include_once("bilgiler.php"); # içe aktarma
        $plaka = $_GET["plaka"]; # tıklanılan butondaki dinamik veriyi yakalama
        if ($plaka==null) $plaka = key($sehirler); 
        # Plaka boş gelirse otomatik olarak dizinin ilk elemanını ata
        echo $sehirler[$plaka]["isim"]; 
        ?>
    </title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

</head>

<body>
    <div class="container mt-2">
        <div class="row">
            <div class="col-md-4 col-lg-4 col-xl-4">
                <div class="d-grid gap-2" role="group" aria-label="Vertical button group">
                    <?php
                        ksort($sehirler); # Plakalara göre küçüktüen büyüğe
                        foreach ($sehirler as $anahtar => $deger) {
                            if($anahtar==$plaka) echo "<a href='sehir.php?plaka=$anahtar' class='btn btn-danger'>$deger[isim]</a>";
                            else echo "<a href='sehir.php?plaka=$anahtar' class='btn btn-primary'>$deger[isim]</a>";
                        }
                    ?>
                </div>
            </div>
            <div class="col-md-8 col-lg-8 col-xl-8">
                <div class="col">
                    <div class="card h-100">
                        <img src="images/<?php echo $sehirler[$plaka]["resim"] ?>" class="card-img-top" alt="...">
                        <div class="card-body">
                            <h5 class="card-title"><?php echo $sehirler[$plaka]["isim"] ?></h5>
                            <p class="card-text"><?php echo $sehirler[$plaka]["bilgi"] ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

</body>

</html>
