<?php 
    require_once("../_ayarlar.php");
    require_once("../_fonksiyonlar.php");
?>
<!DOCTYPE html>
<html lang="tr">

<head>
    <?php include("_head.php") ?>
    <title>Medya Kütüphanesi</title>
</head>

<body id="page-top">

    <!-- Page Wrapper -->
    <div id="wrapper">

        <?php include("_sidebar.php") ?>

        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column">

            <!-- Main Content -->
            <div id="content">

                <?php include("_topbar.php") ?>

                <!-- Sayfaya Özel İçerik -->
                <div class="container-fluid">

                    <div class="card shadow mb-4">
                        <div class="card-header py-3">
                            <h6 class="m-0 font-weight-bold text-primary">Medya Yükle</h6>
                        </div>
                        <form action="medya-yukle.php" method="post" enctype="multipart/form-data">
                            <div class="mb-3">
                                <input type="file" class="form-control" id="dosya" name="dosya">
                            </div>
                            <div class="form-group">
                                <button class="btn btn-primary btn-user btn-block">Medya Yükle</button>
                            </div>
                        </form>
                    </div>

                    <div class="card shadow mb-4">
                        <div class="card-header py-3">
                            <h6 class="m-0 font-weight-bold text-primary">Medya Kütüphanesi</h6>
                        </div>
                        <div class="card-body">

                        <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                                <thead>
                                    <tr>
                                        <th>Dosya Adı</th>                                  
										<th>Küçük Resim</th>                                  
										<th>Bağlantı</th>
                                        <th>Sil</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
                                        <th>Dosya Adı</th>                                  
										<th>Küçük Resim</th>                                  
										<th>Bağlantı</th>
                                        <th>Sil</th>
                                    </tr>
                                </tfoot>
                                <tbody>
                                    <?php
                                    $dizin = opendir("../medya"); //listelenecek dizin
                                    while (($dosya = readdir($dizin)) !== false){ # dizin içerisinde DOSYA olduğu SÜRECE
                                        if(! is_dir($dosya)){  
                                            echo "<tr>";	
                                            echo "<td>$dosya</td>";
                                            echo "<td><img height='50' src='../medya/$dosya'></td>";
                                            echo '<td><input style="position: absolute; left: -1000px; top: -1000px" value="../medya/'.$dosya.'" id="'.$dosya.'"><button class="btn btn-primary" onclick="kopyala(\''.$dosya.'\')">URL Kopyala</button></td>';
                                            echo "<td><a class='btn btn-danger' href='medya-sil.php?id=$dosya'>SİL</a></td>";
                                            echo "</tr>"; 
                                        } 
                                    }
                                    closedir($dizin);
                                    ?>
                                </tbody>
                            </table>

                        </div>
                    </div>

                </div>
                <!-- /.container-fluid -->

            </div>
            <!-- End of Main Content -->

            <?php include("_footer.php") ?>

        </div>
        <!-- End of Content Wrapper -->

    </div>
    <!-- End of Page Wrapper -->

    <!-- Scroll to Top Button-->
    <a class="scroll-to-top rounded" href="#page-top">
        <i class="fas fa-angle-up"></i>
    </a>

    <?php include("_script.php") ?>
</body>

</html>