<?php 
    require_once("../_ayarlar.php");
    require_once("../_fonksiyonlar.php");
?>
<!DOCTYPE html>
<html lang="tr">

<head>
    <?php include("_head.php") ?>
    <title>Yönetim Paneli</title>
</head>

<body id="page-top">

    <!-- Page Wrapper -->
    <div id="wrapper">

        <?php include("_sidebar.php") ?>

        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column">

            <!-- Main Content -->
            <div id="content">

                <?php include("_topbar.php") ?>

                <!-- Sayfaya Özel İçerik -->
                <div class="container-fluid">

                    <!-- Page Heading -->
                    <div class="d-sm-flex align-items-center justify-content-between mb-4">
                        <h1 class="h3 mb-0 text-gray-800">Yönetim Paneli</h1>
                    </div>

                    <!-- Content Row -->
                    <div class="row">

                        <!-- Earnings (Monthly) Card Example -->
                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-primary shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                                KULLANICI SAYISI</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                                <?php

                                                $sql = "SELECT * FROM kullanici";
                                                $tablo = $vt->query($sql);
                                                echo $tablo->num_rows;

                                                ?>
                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-user fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Earnings (Monthly) Card Example -->
                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-success shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                                HABER SAYISI</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                                <?php

                                                echo haber_sayisi();

                                                ?>
                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-newspaper fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Earnings (Monthly) Card Example -->
                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-info shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                            ONAY BEKLEYEN YORUM SAYISI</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                                <?php

                                                $sql = "SELECT * FROM yorum WHERE onay = 0 ";
                                                $tablo = $vt->query($sql);
                                                echo $tablo->num_rows;

                                                ?>
                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-comment fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Pending Requests Card Example -->
                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-warning shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                                TOPLAM HABER ZİYARETİ</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                                <?php

                                                $sql = "SELECT * FROM okunma";
                                                $tablo = $vt->query($sql);
                                                echo $tablo->num_rows;

                                                ?>
                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-eye fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Content Row -->

                    <div class="row">

                    <!-- Content Column -->
                        <div class="col-lg-8 mb-7">

                            <!-- Project Card Example -->
                            <div class="card shadow mb-4">
                                <div class="card-header py-3">
                                    <h6 class="m-0 font-weight-bold text-primary">KATEGORİ YÜZDELERİ</h6>
                                </div>
                                <div class="card-body">
                                    <?php
                                        $sql = "SELECT * FROM kategori";
                                        $tablo = $vt->query($sql);
                                        while($satir=$tablo->fetch_array()){
                                            $renk_kodu = rand(100000,999999);
                                            $yuzde = kategorik_haber_sayisi($satir["kategori_id"]) / haber_sayisi() * 100;
                                        
                                            $adlar[] = "'".$satir["kategori_ad"]."'";
                                            $renkler[] = "'#".$renk_kodu."'";
                                            $yuzdeler[] = $yuzde;

                                        echo '<h4 class="small font-weight-bold">'.$satir["kategori_ad"].' <span
                                                class="float-right">'.$yuzde.'%</span></h4>
                                        <div class="progress mb-4">
                                            <div class="progress-bar" role="progressbar" style="width: '.$yuzde.'%; background-color:#'.$renk_kodu.'"
                                                aria-valuenow="'.$yuzde.'" aria-valuemin="0" aria-valuemax="100"></div>
                                        </div>';
                                    }
                                    ?>
                                </div>
                            </div>
                        </div>

                        <!-- Pie Chart -->
                        <div class="col-xl-4 col-lg-5">
                            <div class="card shadow mb-4">
                                <!-- Card Header - Dropdown -->
                                <div
                                    class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                                    <h6 class="m-0 font-weight-bold text-primary">KATEGORİ DAĞILIMI</h6>
                                </div>
                                <!-- Card Body -->
                                <div class="card-body">
                                    <div class="chart-pie pt-4 pb-2">
                                        <canvas id="myPieChart"></canvas>
                                    </div>
                                    <div class="mt-4 text-center small">
                                        <?php
                                            foreach ($adlar as $anahtar => $deger) {
                                                echo '<span class="mr-2">
                                                    <i class="fas fa-circle" style="color:'.str_replace("'","",$renkler[$anahtar]).'"></i> '.str_replace("'","",$deger).'
                                                </span>';
                                            }
                                        ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                        
                    </div>
                </div>
                <!-- /.container-fluid -->

            </div>
            <!-- End of Main Content -->

            <?php include("_footer.php") ?>

        </div>
        <!-- End of Content Wrapper -->

    </div>
    <!-- End of Page Wrapper -->

    <!-- Scroll to Top Button-->
    <a class="scroll-to-top rounded" href="#page-top">
        <i class="fas fa-angle-up"></i>
    </a>

    <?php include("_script.php") ?>
    <script>
        Chart.defaults.global.defaultFontFamily = 'Nunito', '-apple-system,system-ui,BlinkMacSystemFont,"Segoe UI",Roboto,"Helvetica Neue",Arial,sans-serif';
        Chart.defaults.global.defaultFontColor = '#858796';

        // Pie Chart Example
        var ctx = document.getElementById("myPieChart");
        var myPieChart = new Chart(ctx, {
        type: 'doughnut',
        data: {
            labels: [<?php echo implode(", ", $adlar); ?>],
            datasets: [{
            data: [<?php echo implode(", ", $yuzdeler); ?>],
            backgroundColor: [<?php echo implode(", ", $renkler); ?>],
            hoverBackgroundColor: [],
            hoverBorderColor: "rgba(234, 236, 244, 1)",
            }],
        },
        options: {
            maintainAspectRatio: false,
            tooltips: {
            backgroundColor: "rgb(255,255,255)",
            bodyFontColor: "#858796",
            borderColor: '#dddfeb',
            borderWidth: 1,
            xPadding: 15,
            yPadding: 15,
            displayColors: false,
            caretPadding: 10,
            },
            legend: {
            display: false
            },
            cutoutPercentage: 80,
        },
        });
    </script>
</body>

</html>