<?php 
    require_once("../_ayarlar.php");
    require_once("../_fonksiyonlar.php");
?>
<!DOCTYPE html>
<html lang="tr">

<head>
    <?php include("_head.php") ?>
    <title>Yorumlar</title>
</head>

<body id="page-top">

    <!-- Page Wrapper -->
    <div id="wrapper">

        <?php include("_sidebar.php") ?>

        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column">

            <!-- Main Content -->
            <div id="content">

                <?php include("_topbar.php") ?>

                <!-- Sayfaya Özel İçerik -->
                <div class="container-fluid">

                    <div class="card shadow mb-4">
                        <div class="card-header py-3">
                            <h6 class="m-0 font-weight-bold text-primary">Yorumlar</h6>
                        </div>
                        <div class="card-body">

                            <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                                <thead>
                                    <tr>
                                        <th>Sıra No</th>
                                        <th>Haber</th>
                                        <th>Ekleyen</th>
                                        <th>Yorum</th>
                                        <th>Zaman</th>
                                        <th>Sil</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
                                        <th>Sıra No</th>
                                        <th>Haber</th>
                                        <th>Ekleyen</th>
                                        <th>Yorum</th>
                                        <th>Zaman</th>
                                        <th>Sil</th>
                                    </tr>
                                </tfoot>
                                <tbody>
                                    <?php
                                    $sql = "SELECT yorum.id AS id, yorum.yorum, yorum.zaman, haber.id AS haberid, haber.baslik, kullanici.id AS kullaniciid, kullanici.ad, kullanici.soyad FROM yorum INNER JOIN haber on yorum.haber = haber.id INNER JOIN kullanici ON yorum.ekleyen = kullanici.id WHERE onay = '1' ORDER BY yorum.id DESC";
                                    $tablo = $vt->query($sql);
                                    $sira = 1;
                                    while ($satir = $tablo->fetch_assoc()) {
                                        $baslik = $satir["baslik"];
                                        $ekleyen = $satir["ad"]." ".$satir["soyad"];
                                        $yorum = $satir["yorum"];
                                        $zaman = tarih_donustur($satir["zaman"]);
                                        echo "<tr>
                                                    <td>" . $sira . "</td>
                                                    <td>" . $baslik . "</td>
                                                    <td>" . $ekleyen . "</td>
                                                    <td>" . $yorum . "</td>
                                                    <td>" . $zaman . "</td>
                                                    <td><a href='yorum-sil.php?id=" . $satir["id"] . "'><button class='btn btn-danger'>Sil</button></a></td>
                                                </tr>";
                                        $sira++;
                                    }
                                    ?>
                                </tbody>
                            </table>

                        </div>
                    </div>

                </div>
                <!-- /.container-fluid -->

            </div>
            <!-- End of Main Content -->

            <?php include("_footer.php") ?>

        </div>
        <!-- End of Content Wrapper -->

    </div>
    <!-- End of Page Wrapper -->

    <!-- Scroll to Top Button-->
    <a class="scroll-to-top rounded" href="#page-top">
        <i class="fas fa-angle-up"></i>
    </a>

    <?php include("_script.php") ?>
</body>

</html>